// Step 3 page JavaScript
document.addEventListener('DOMContentLoaded', function() {
    console.log('AED Step 3 page loaded successfully');
    
    // Get the draggable pad elements
    const padImage1 = document.querySelector('.pad-image-1');
    const padImage2 = document.querySelector('.pad-image-2');
    
    // Get the target rectangles (green pad positions)
    const targetRect1 = document.querySelector('.pad-position-upper-right'); // Rectangle 3 (node-id 16:539)
    const targetRect2 = document.querySelector('.pad-position-lower-left');  // Rectangle 7 (node-id 16:551)
    
    // Track collision states
    let pad1OnTarget = false;
    let pad2OnTarget = false;
    
    // Make pads draggable
    makeDraggable(padImage1, targetRect1, 'pad1');
    makeDraggable(padImage2, targetRect2, 'pad2');
    
    function makeDraggable(element, targetRect, padId) {
        let isDragging = false;
        let currentX;
        let currentY;
        let initialX;
        let initialY;
        let xOffset = 0;
        let yOffset = 0;
        
        // Mouse events
        element.addEventListener('mousedown', dragStart);
        document.addEventListener('mousemove', drag);
        document.addEventListener('mouseup', dragEnd);
        
        // Touch events for mobile
        element.addEventListener('touchstart', dragStart);
        document.addEventListener('touchmove', drag);
        document.addEventListener('touchend', dragEnd);
        
        function dragStart(e) {
            if (e.type === 'touchstart') {
                initialX = e.touches[0].clientX - xOffset;
                initialY = e.touches[0].clientY - yOffset;
            } else {
                initialX = e.clientX - xOffset;
                initialY = e.clientY - yOffset;
            }
            
            if (e.target === element || element.contains(e.target)) {
                isDragging = true;
                element.style.cursor = 'grabbing';
            }
        }
        
        function drag(e) {
            if (isDragging) {
                e.preventDefault();
                
                if (e.type === 'touchmove') {
                    currentX = e.touches[0].clientX - initialX;
                    currentY = e.touches[0].clientY - initialY;
                } else {
                    currentX = e.clientX - initialX;
                    currentY = e.clientY - initialY;
                }
                
                xOffset = currentX;
                yOffset = currentY;
                
                setTranslate(currentX, currentY, element);
                
                // Check collision during drag
                checkCollision(element, targetRect, padId);
            }
        }
        
        function dragEnd(e) {
            if (isDragging) {
                initialX = currentX;
                initialY = currentY;
                isDragging = false;
                element.style.cursor = 'grab';
                
                // Final collision check
                checkCollision(element, targetRect, padId);
            }
        }
        
        function setTranslate(xPos, yPos, el) {
            el.style.transform = `translate3d(${xPos}px, ${yPos}px, 0)`;
        }
        
        // Set initial cursor
        element.style.cursor = 'grab';
    }
    
    function checkCollision(pad, target, padId) {
        const padRect = pad.getBoundingClientRect();
        const targetRect = target.getBoundingClientRect();
        
        // Check if the pad overlaps with the target rectangle
        const isColliding = !(
            padRect.right < targetRect.left ||
            padRect.left > targetRect.right ||
            padRect.bottom < targetRect.top ||
            padRect.top > targetRect.bottom
        );
        
        // Update collision state for this pad
        if (padId === 'pad1') {
            pad1OnTarget = isColliding;
        } else if (padId === 'pad2') {
            pad2OnTarget = isColliding;
        }
        
        // Check if both pads are on their targets
        if (pad1OnTarget && pad2OnTarget) {
            console.log('Both pads correctly placed! Navigating to Step 4...');
            // Navigate to step 4
            window.location.href = 'step4.html';
        }
    }
});
